clear all;  % Clear all variables from the workspace
close all;  % Close all open figures
clc;        % Clear the command window

% Define the desired coordinates
desired_x = 0.31;  % Desired x-coordinate in meters
desired_y = 0.11;  % Desired y-coordinate in meters

% Define the search range for theta1 from 0° to 90°
theta1_range = 0:0.01:pi/2;  % Range of theta1 from 0 to 90 degrees in radians

% Initialize variables to store the closest angles and their corresponding coordinates
closest_theta1 = 0;
closest_theta2 = 0;
closest_distance = inf;

% Loop through all combinations of theta1 and theta2
for theta1 = theta1_range
    for theta2 = theta1_range
        % Calculate the coordinates for the current angles
        [xA, yA] = calculateCoordinates(theta1, theta2);
        
        % Calculate the distance between the current coordinates and the desired coordinates
        distance = sqrt((xA - desired_x)^2 + (yA - desired_y)^2);
        
        % Check if the current distance is smaller than the closest distance so far
        if distance < closest_distance
            % Update the closest angles and distance
            closest_theta1 = theta1;
            closest_theta2 = theta2;
            closest_distance = distance;
        end
    end
end

% Save the closest angles to a text file
fileID = fopen('closest_angles.txt', 'w');
fprintf(fileID, 'Closest Angles:\n');
fprintf(fileID, 'Theta1: %.2f degrees\n', rad2deg(closest_theta1));
fprintf(fileID, 'Theta2: %.2f degrees\n', rad2deg(closest_theta2));
fclose(fileID);

fprintf('Closest angles saved to "closest_angles.txt" file.\n');

% Calculate the trajectory assuming starting from 0° for both angles
theta1_traj_0 = 0:0.01:closest_theta1;
theta2_traj_0 = linspace(0, closest_theta2, numel(theta1_traj_0));
[x_traj_0, y_traj_0] = calculateCoordinates(theta1_traj_0, theta2_traj_0);

% Calculate the trajectory assuming starting from 0° for theta1 and an arbitrary angle for theta2
theta2_arbitrary = 0.75 * closest_theta2;  % Assuming an arbitrary angle for theta2
theta1_traj_arb = linspace(0, closest_theta1, numel(theta1_traj_0));
theta2_traj_arb = linspace(theta2_arbitrary, closest_theta2, numel(theta1_traj_arb));
[x_traj_arb, y_traj_arb] = calculateCoordinates(theta1_traj_arb, theta2_traj_arb);

% Plot the trajectory assuming starting from 0° for both angles
figure;
plot(x_traj_0, y_traj_0, 'b-', 'LineWidth', 2);
xlabel('x (m)');
ylabel('y (m)');
title('Trajectory of Point A (Starting from 0° for both angles)');
grid on;

% Plot the trajectory assuming starting from 0° for theta1 and an arbitrary angle for theta2
figure;
plot(x_traj_arb, y_traj_arb, 'r-', 'LineWidth', 2);
xlabel('x (m)');
ylabel('y (m)');
title('Trajectory of Point A (Starting from 0° for theta1 and arbitrary angle for theta2)');
grid on;
