clear all;  % Clear all variables from the workspace
close all;  % Close all open figures
clc;        % Clear the command window

% Initialize arrays to store the integer numbers and the corresponding iterations
numbers = 2:50;
iterations = zeros(size(numbers));

% Compute the iterations for each integer using the computeSequence function
for i = 1:numel(numbers)
    [~, iterations(i)] = computeSequence(numbers(i));
end

% Plot the number of iterations versus the integer number
plot(numbers, iterations, 'o-');
xlabel('Integer Number');
ylabel('Number of Iterations');
title('Number of Iterations vs Integer Number');
grid on;
