clear all;  % Clear all variables from the workspace
close all;  % Close all open figures
clc;        % Clear the command window

% Ask user for input
number = input("Enter a number: ");

% Check if the given number is reversible
if is_reversible_number(number)
    fprintf("Number %d is Reversible.\n", number);  % Print the number is reversible
else
    result = is_reversible(number);  % Calculate if the number is eventually reversible or unreversible
    if strcmp(result, "Unreversible")
        fprintf("Number %d is %s\n", number, result);  % Print the number is unreversible
    end
end

% Function to check if a number is eventually reversible
function result = is_reversible(n)
    n_main = n;  % Store the original number
    for i = 1:100
        n = n + reverse_number(n);  % Calculate the sum of the number and its reverse
        if is_reversible_number(n)  % Check if the sum is reversible
            fprintf("Number %d is eventually reversible after %d iteration(s).\n", n_main, i);
            result = "Eventually Reversible";
            return;
        end
    end
    result = "Unreversible";
end

% Function to reverse the digits of a number
function reversed = reverse_number(n)
    reversed = str2double(fliplr(num2str(n)));  % Convert the reversed string back to a number
end

% Function to check if a number is reversible
function result = is_reversible_number(n)
    result = strcmp(num2str(n), fliplr(num2str(n)));  % Compare the number with its reversed string representation
end