clear all;  % Clear all variables from the workspace
close all;  % Close all open figures
clc;        % Clear the command window

% Ask the user to input a word
word = input("Enter a word: ", 's');

% Convert the word to lowercase
word = lower(word);

% Check if the word is a palindrome
isPalindrome = checkPalindrome(word);
fprintf("Is the word '%s' a palindrome? %s\n", word, string(isPalindrome));

% Read the words from the text file
fileID = fopen('words.txt', 'r');
words = textscan(fileID, '%s', 'Delimiter', '\n');
words = words{1};
fclose(fileID);

% Create a new text file for palindromes
fileID = fopen('palindromes.txt', 'w');

% Check each word from the file if it is a palindrome and save it to the palindromes text file
for i = 1:numel(words)
    word = words{i};
    word = lower(word); % Convert the word to lowercase
    isPalindrome = checkPalindrome(word);
    if isPalindrome
        fprintf(fileID, "%s\n", word);  % Save the palindrome to the file
    end
end

fclose(fileID);
fprintf("Palindromes saved to 'palindromes.txt' file.\n");

% Function to check if a word is a palindrome
function isPalindrome = checkPalindrome(word)
    reversedWord = fliplr(word);  % Reverse the word
    isPalindrome = strcmp(word, reversedWord);  % Compare the word with its reversed form
end
