function [sequence, iterations] = computeSequence(n)
    % Initialize the sequence with the input value
    sequence = [n];
    
    % Initialize the iteration count
    iterations = 0;
    
    % Perform the sequence calculation until n becomes 1
    while n > 1
        % Check if n is even
        if mod(n, 2) == 0
            n = n / 2; % Halve the value
        else
            n = 3 * n + 1; % Multiply by 3 and add 1
        end
        
        % Append the updated value to the sequence
        sequence = [sequence, n];
        
        % Increment the iteration count
        iterations = iterations + 1;
    end
end
