function [Vout, Iout] = solar_panel(Nrow, Ncol)
% Constants
V_PER_ROW = 0.6; % Volts per row
I_PER_COL = 50; % Milliamps per column

% Calculate output voltage and current
Vout = Nrow * V_PER_ROW; % Volts
Iout = Ncol * I_PER_COL / 1000; % Amps (converted from milliamps)

end
