function [Voptimal, Ioptimal] = pd_optimal(illum)

illum_current = containers.Map('KeyType','double','ValueType','double');
illum_current(500) = 0.21;
illum_current(600) = 0.3;
illum_current(700) = 0.4;
illum_current(800) = 0.5;
illum_current(900) = 0.6;
illum_current(1000) = 0.6;
illum_current(1100) = 0.7;
illum_current(1200) = 0.8;
illum_current(1300) = 0.9;
illum_current(1400) = 1.1;

% Calculate output voltage and current
Voptimal = 1.5 * 0.026 * (log(illum_current(illum)/(0.6*1e-6)) + 1) - 0.093; % Volts
Ioptimal = illum_current(illum) - 0.6*1e-6 * (exp(Voptimal/(1.5 * 0.026)) - 1); % Amps 

end
