function myOutput = myNewton(NumIteration)
% Define anonymous functions
R = 10;
Ilight = 0.5;
Idark = 0.6*1e-6;
Vt = 26*1e-3;

f = @(Vout) Ilight - Idark*(exp(Vout/Vt) - 1) - (Vout/R);
df = @(Vout) (-1/Vt)*Idark*exp(Vout/Vt) - (1/R);

% Initial guess for Vout
Vout_guess = 0;

% Perform Newton's method
for i = 1:NumIteration
    Vout_new = Vout_guess - f(Vout_guess)/df(Vout_guess);
    Vout_guess = Vout_new;
end

% Return final Vout estimate
myOutput = Vout_guess;
end
