function z = element_wise_multiply(x, y)

% Check that matrices x and y have the same dimensions
if size(x) ~= size(y)
    error('Matrices must have the same dimensions')
end

% Initialize the output matrix z with zeros
z = zeros(size(x));

tic
% Loop over each element in each row and column of x and y
for i = 1:size(x,1)
    for j = 1:size(x,2)
        % Multiply the corresponding elements in x and y and store result in z
        z(i,j) = x(i,j) * y(i,j);
    end
end
toc
end