#include <stdlib.h>
#include <string.h>
#include <string.h>

#include "pa3.h"
#include "test.h" /* For TEST() macro and stdio.h */

/*
 * Unit Test for hash.c
 *
 * unsigned int hash( char * src );
 *
 */
void testparseNum() {
	char buffer[16];
	char *argv[2] = {NULL, (char *)buffer};
	strcpy(argv[1], "0xFFFFFFFF");
	TEST(parseNum(argv) == 0xFFFFFFFF);
	strcpy(argv[1], "0x00000000");
	TEST(parseNum(argv) == 0x00000000);
	strcpy(argv[1], "0xadfadfkhj");
	TEST(parseNum(argv) == 0xFFFFFFFF);
	strcpy(argv[1], "0x4160000x");
	TEST(parseNum(argv) == 0xFFFFFFFF);
	strcpy(argv[1], "0x41600000");
	TEST(parseNum(argv) == 0x41600000);
	strcpy(argv[1], "0x80000000");
	TEST(parseNum(argv) == 0x80000000);
	strcpy(argv[1], "0x0000FFFF");
	TEST(parseNum(argv) == 0x0000FFFF);
}

int main() {
  fprintf(stderr, "Testing parseNum...\n\n");
  testparseNum();
  fprintf(stderr, "\nDone running tests.\n");
  return 0;
}
