#include <stdlib.h>
#include <string.h>
#include <string.h>

#include "pa3.h"
#include "test.h" /* For TEST() macro and stdio.h */

/*
 * Unit Test for hash.c
 *
 * void extractParts(unsigned long ieeeBin, ieeeParts_t * fill);
 *
 */
void testextractParts() {
	ieeeParts_t fp;
	extractParts(0xffffffff, &fp);
	TEST(((fp.sign == 1) && (fp.exp == -128) && (fp.mantissa == 0xffffff)));
	extractParts(0xf47a0000, &fp);
	TEST(((fp.sign == 1) && (fp.exp == 105) && (fp.mantissa == 16384000)));
	extractParts(0x240a0010, &fp);
	TEST(((fp.sign == 0) && (fp.exp == -55) && (fp.mantissa == 9043984)));
	extractParts(0x04020010, &fp);
	TEST(((fp.sign == 0) && (fp.exp == -119) && (fp.mantissa == 8519696)));
	extractParts(0xcc000010, &fp);
	TEST(((fp.sign == 1) && (fp.exp == 25) && (fp.mantissa == 8388624)));
	extractParts(0xc0418010, &fp);
	TEST(((fp.sign == 1) && (fp.exp == 1) && (fp.mantissa == 12681232)));
	extractParts(0x80d78010, &fp);
	TEST(((fp.sign == 1) && (fp.exp == -126) && (fp.mantissa == 14123024)));
}

int main() {
  fprintf(stderr, "Testing parseNum...\n\n");
  testextractParts();
  fprintf(stderr, "\nDone running tests.\n");
  return 0;
}
