	.arch armv6		@ armv6 instruction set
	.cpu cortex-a53		@ cputype
	.syntax unified		@ allow modern syntax
	
	.globl extractParts	@ void extractParts( unsigned long ieeeBin, ieeeParts_t * fill );
	.text
extractParts:
	push {lr}		@ save return address

	lsl r2, r0, #9
	lsr r2, r2, #9		@ mask upper 9 bits
	str r2, [r1, #4]
	
	lsr r0, r0, #23		@ shift out the mantissa
	and r3, r0, #0xff	@ clear the sign bit
	sub r3,	r3, #127	@ subtract by 127 to unbias the exponent	
	strb r3, [r1, #1]	@ store the exponent
		
	cmp r3, #-127		@ check special cases
	beq denormalized	
	ldrb r2, [r1, #6]
	add r2, r2, #0x80
	strb r2, [r1, #6]	@ add 1 to 24th bit for normalized values i.e. exponent != 0
	b   normalized

denormalized:
	tst r2, r2		@ check the mantissa
	beq zero		@ store exponent zero is mantiss is also zero
	ldrb r2, [r1, #1]
	add r2, r2, #1		@ denormalized value exponent is incremented
	strb r2, [r1, #1]	@ store the exponent
	b   normalized

zero:
	mov r2, #0
	strb r2, [r1, #1]	@ store the exponent

normalized:

	lsr r0, r0, #8		@ shift out the exponent
	strb r0, [r1, #0] 	@ store the sign
	
	pop {pc}		@ return from the subroutine

