var clientMain = (function () {
    "use strict";

    // TODO update url_root to point to your user account
    var url_root = "http://localhost/Programming_PHP_14th%20Sep";
    var posts = Immutable.List();
    var error = null;
    var last_post_time = null;

    var render_posts;

    var deleteExitingPosts =  function () {
        var url = url_root + "/delete.php";
        $.post(url) .done(function (data) {
        	console.log(data);
        });
    };
    
    deleteExitingPosts();

    var post = function () {
        var url = url_root + "/post.php";
        $.post(url, {message: $("#postin").val()})
            .done(function (data) {
                if (data.hasOwnProperty("error")) {
                    error = data.error;
                    render_posts();
                } else {
                    get_posts(last_post_time);
                    error = null;
                }
            })
            .fail(function (err) {
                alert("There was an error requesting your post.php, probably due to an error in this script. Check the web console for more information on this error.");
                console.log(JSON.stringify(err));
            });
    };

    var get_posts = function (since) {
        var request;
        var url = url_root + "/getposts.php";
        if (since === null) {
            request = $.get(url);
        } else {
            request = $.get(url, {since: String(since)});
        }

        request
            .done(function (data) {
            var i;
            if (data.hasOwnProperty("error")) {
                error = data.error;
            } else {
                for (i = 0; i < data.posts.length; i++) {
                    posts = posts.push(data.posts[i]);
                }

                if (data.posts.length > 0) {
                    last_post_time = data.posts[data.posts.length - 1].time;
                }
            }

            render_posts();
        })
            .fail(function (err) {
                alert("There was an error requesting your getposts.php, probably due to an error in this script. Check the web console for more information on this error.");
                console.log(JSON.stringify(err));
            });
    };

    var post_to_div = function (post) {
        var days = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                      "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        var date = new Date(1000*post.time);

        var hours = date.getHours();
        var mins = "0" + date.getMinutes();
        var formattedTime = hours + ":" + mins.substr(-2);

        var weekday = days[date.getDay()];
        var day = date.getDate();
        var month = months[date.getMonth()];
        var year = date.getFullYear();

        var formattedDate = weekday + " " + day + " " + month + " " + year;

        return VDOM.h("div",
                      {style: {
                          border: "1px solid black",
                          marginTop: "10px",
                          clear: "both"
                      }},
                      [ VDOM.h("div",
                               {style: {
                                   padding: "5px",
                                   backgroundColor: "#f2f2f2"
                               }},
                               [formattedTime + " " + formattedDate]),
                        VDOM.h("div",
                               {style: {
                                   padding: "5px"
                               }},
                               [VDOM.h("p", {}, String(post.message))])
                      ]);
    };

    var view_posts = function() {
        var i;
        var error_div;
        var divs;
        var post_divs = posts.reverse().map(post_to_div);
        if (error === null) {
            divs = post_divs;
        } else {
            error_div = VDOM.h("div",
                               {style: {
                                   border: "2px solid crimson",
                                   marginTop: "10px",
                                   padding: "5px",
                                   backgroundColor: "#ffe6e6",
                                   clear: "both"
                               }},
                               [ String(error) ]);
            divs = post_divs.insert(0, error_div);
        }

        return VDOM.h("div", {}, divs.toJS());
    };

    return function () {
        render_posts = (function () {
            var tree = view_posts();
            var root = VDOM.createElement(tree);
            document.getElementById("posts").appendChild(root);

            return function () {
                var new_tree = view_posts();
                var patches = VDOM.diff(tree, new_tree);
                root = VDOM.patch(root, patches);
                tree = new_tree;
            };
        })();

        $("#postsub").on("click", post);
        get_posts(last_post_time);
        setInterval(function () { get_posts(last_post_time); }, 3000);
    };
})();

$(document).ready(clientMain);
