#include<iostream>
#include <sstream>
using namespace std;

int BOARD_SIZE = 8;
char BOARD[8][8];
char PIECES[6] = {'R', 'N', 'B', 'Q', 'K', 'P'};

void setupBoard(){
    int i,j;
    for(i=0; i<BOARD_SIZE;i++){
        for(j=0;j<BOARD_SIZE;j++){
            BOARD[i][j] = ' ';
        }
    }

    for(j=0; j < BOARD_SIZE;j++){
        BOARD[1][j] = 'P';
    }

    BOARD[0][0] = 'R';
    BOARD[0][7] = 'R';

    BOARD[0][1] = 'N';
    BOARD[0][6] = 'N';

    BOARD[0][2] = 'B';
    BOARD[0][5] = 'B';

    BOARD[0][3] = 'Q';
    BOARD[0][4] = 'K';



}

void displayBoard(){
    int i,j;
    char vars[8] = {'A','B','C','D','E','F','G','H'};
    printf("%4s","");
    for(i=0; i <BOARD_SIZE;i++)
        printf("%3c   ",vars[i]);
    printf("\n   ");

    for(i =0 ;i <49;i++)
        printf("-");
    printf("\n");

    for(i=0; i<BOARD_SIZE;i++){
        printf("%2d |",i+1);
        for(j=0;j<BOARD_SIZE;j++){
            printf("%3c  |",BOARD[i][j]);
        }
        printf("\n   ");
        for(j =0 ;j <49;j++)
            printf("-");
        printf("\n");
    }
}

int cordToY(string input){
    string b(1,input.at(1));
    stringstream data(b);
    int vIndex = 0;
    data >> vIndex;
    return --vIndex;
}

int cordToX(string input){
    char a = input.at(0);
    char vars[8] = {'A','B','C','D','E','F','G','H'};
    for(int i = 0; i < BOARD_SIZE;i++){
        if(a == vars[i]){
            return i;
        }
    }
    return -1;
}

char getPiece(string input){
    if(input.length() != 2){
        cout<<"Invalid Length. Retry."<<endl;
        return '-';
    }
    char a = input.at(0);
    string b(1,input.at(1));

    stringstream data(b);
    int vIndex = 0;
    data >> vIndex;

    int i, j;
    char vars[8] = {'A','B','C','D','E','F','G','H'};
    int hIndex = -1;
    for(i = 0; i < BOARD_SIZE;i++){
        if(a == vars[i]){
            hIndex = i;
            break;
        }
    }
    if(hIndex == -1){
        cout<<"Invalid X co-ordinate. Retry."<<endl;
        return '-';
    }
    if(vIndex < 1 or vIndex > 8){
        cout<<"Invalid Y co-ordinate. Retry."<<endl;
        return '-';
    }
    vIndex--;
    if(BOARD[vIndex][hIndex] == ' '){
        cout<<"No Piece at choosen location. Retry."<<endl;
        return '-';
    }
    return BOARD[vIndex][hIndex];
}

string indexToCord(int i, int j){
    char vars[8] = {'A','B','C','D','E','F','G','H'};
    string c(1, vars[i]);
    return c + to_string(j+1);
}

string* recursive(string* data, int* count, int x, int y, int nX, int nY, int limit){
    if(x > 7 or x < 0 or y > 7 or y < 0 or BOARD[y][x] != ' ' or limit == 0)
        return data;
    data[*count] = indexToCord(x,y);
    (*count)++;

    return recursive(data, count, x + nX, y + nY, nX, nY, --limit);
}

string* possibleMoves(string input){
    string* data = new string[50];
    int start = 0;
    for(int i=0; i < 50; i++){
        data[i] = "-";
    }

    int X = cordToX(input);
    int Y = cordToY(input);
    int xT = X;
    int yT = Y;
    char piece = BOARD[Y][X];
    if(piece == 'P'){
        int limit = 1;
        if(Y == 1)
            limit = 2;
        data = recursive(data, &start, X, Y+1, 0, 1, limit);
    }
    if(piece == 'R'){
        data = recursive(data, &start, X+1, Y, 1, 0, 50);
        data = recursive(data, &start, X-1, Y, -1, 0 , 50);
        data = recursive(data, &start, X, Y+1, 0, 1 , 50);
        data = recursive(data, &start, X, Y-1, 0, -1, 50);
    }
    if(piece == 'B'){
        data = recursive(data, &start, X+1, Y+1, 1, 1, 50);
        data = recursive(data, &start, X+1, Y-1, 1, -1, 50);
        data = recursive(data, &start, X-1, Y-1, -1, -1, 50);
        data = recursive(data, &start, X-1, Y+1, -1, 1, 50);
    }
    if(piece == 'Q'){
        for(int a = -1; a < 2; a++)
            for(int b = -1; b < 2; b++)
                if(a !=0 or b!=0)
                    data = recursive(data, &start, X+a, Y+b, a, b, 50);

    }
    if(piece == 'K'){
        for(int a = -1; a < 2; a++)
            for(int b = -1; b < 2; b++)
                if(a !=0 or b!=0)
                    data = recursive(data, &start, X+a, Y+b, a, b, 1);

    }
    if(piece == 'N'){
        int p1[8] = {2,2,-2,-2,1,1,-1,-1};
        int p2[8] = {1,-1,1,-1,2,-2,2,-2};
        for(int a = 0; a < 8; a++)
            data = recursive(data, &start, X+p1[a], Y+p2[a], p1[a], p2[a], 1);

    }
    
    
    return data;

}

void makeMove(string input){
    string* data = possibleMoves(input);
    int X = cordToX(input);
    int Y = cordToY(input);
    cout<<"Possible move: ";
    if(data[0] == "-"){
        cout<<"No Possible Moves for this piece. Retry."<<endl;
    }
    else{
        for(int i =0; i<50;i++){
            if(data[i] == "-")
                break;
            cout<<data[i]<<" ";
        }
        cout<<endl<<endl;

        string choice;
        cout<<"Select one possible move from the above or press N to choose another piece : ";
        cin>>choice;

        for(int i =0; i<50;i++){
            if(choice == data[i]){
                int nX = cordToX(choice);
                int nY = cordToY(choice);
                BOARD[nY][nX] = BOARD[Y][X];
                BOARD[Y][X] = ' ';
                cout<<"\nMove Successful\n"<<endl;
                return;
            }
        }
        cout<<"\nInvalid Position Selected\n"<<endl;
    }
}

string menu(){
    string choice;
    cout<<"\nMenu:\n-----\n";
    cout<<"1. Start New game\n";
    cout<<"2. Continue\n";
    cout<<"3. Show Board\n";
    cout<<"Any Other Key to exit\n";
    cout<<"Choose: ";
    cin>>choice;
    return choice;
}

void askForMove(){
    displayBoard();
    string input;
    cout<<"\nWhat piece you want to move (LETTER THEN NUMBER ): ";
    cin>>input;
    char result = getPiece(input);
    cout<<endl;
    if(result == '-')
        return;
    else
        makeMove(input);
}

int main(){
    setupBoard();
    string choice = "1";
    while(choice != "4"){
        choice = menu();  
        if(choice == "1"){
            setupBoard();
            askForMove();
        }
        else if(choice == "2"){
            askForMove();
        }
        else if(choice == "3"){
            displayBoard();
        }
        else{
            cout<<"\nGoodBye\n";
            break;
        }    
    }
}



