library(sparseIndexTracking)
library(ggplot2)
library(quadprog)
library(quantmod)
library(combinat)
library(fPortfolio)
library(PortfolioAnalytics)
library(PerformanceAnalytics)
require(lubridate)
library(stringr)

## Retrieving stock prices and calculating returns
ticker_list = c("BND","VB","VEA","VOO","VWO")
prices <- NULL
start_date = '2013-01-01'
for (ticker in ticker_list){
  prices <- cbind(prices, 
                  getSymbols.yahoo(ticker,from = start_date, 
                                   periodicity= 'daily', auto.assign=FALSE)[,4])
}
rets = na.omit(ROC(prices))
colnames(rets) = ticker_list

# subset for the period 01-01-2013 to 2018-03-01  
rets1 = rets
rets1 <- rets1["2013-01-01/2018-03-01"] 

# Q1. Mean daily return
port.weights <-as.matrix(c(0.10,0.20,0.25,0.25,0.20))
averages<-as.matrix(c(mean(rets1$BND),mean(rets1$VB),mean(rets1$VEA),
                    mean(rets1$VOO),mean(rets1$VWO)))
port.mean<-round(t(port.weights)%*%averages,6)
port.mean #mean daily return

# Q1. Variance/covariance matrix
varcovar <-cov(rets)
varcovar
averages

# Q2. Optimal portfolio weights
rets2 = as.timeSeries(rets1)
optport = tangencyPortfolio(rets2,constraints="LongOnly")
optport.weights = getWeights(optport)
optport.weights #optimal portfolio weights

# Q2. efficient frontier
front <-portfolioFrontier(rets2,constraints="LongOnly")
plot(front,c(1,2,3,4))

# subset for the period 03-02-2018 to 02-03-2021  
rets3 <- rets["2018-02-03/2021-03-02"] 

# Q3. Mean daily return
averages1<-as.matrix(c(mean(rets3$BND),mean(rets3$VB),mean(rets3$VEA),
                      mean(rets3$VOO),mean(rets3$VWO)))
port.mean1<-round(t(port.weights)%*%averages1,6)
port.mean1 #mean daily return

# Q3. Variance/covariance matrix
varcovar1 <-cov(rets3)
varcovar1

# Q3. Optimal portfolio weights
rets4 = as.timeSeries(rets3) #creating formal timeseries object
optport1 = tangencyPortfolio(rets4,constraints = "LongOnly")
optport1.weights = getWeights(optport1)
optport1.weights
optport1
optport

# Q3. efficient frontier
front1 <-portfolioFrontier(rets4,constraints="LongOnly")
plot(front1,c(1,2,3,4))

# Q4. Daily Returns Distribution with Initial portfolio weights 01/01/2013 to 01/03/2018
port.returns= rets1%*%port.weights
initialreturns=as.data.frame(port.returns)
ggplot(initialreturns,aes(V1))+geom_histogram(color="black",fill="white")+
  theme_bw()+ggtitle("Daily Returns with Initial Weights 01/01/2013 to 01/03/2018")+
  labs(x = "Daily returns")

# Q4. Daily Returns Distribution with Optimal portfolio weights 01/01/2013 to 01/03/2018
optport.returns=rets1%*%unname(optport.weights)
optreturns=as.data.frame(optport.returns)
ggplot(optreturns,aes(V1))+geom_histogram(color="black",fill="white")+
  theme_bw()+ggtitle("Daily Returns with Optimal Weights 01/01/2013 to 01/03/2018")+
  labs(x = "Daily returns")

# Q4. Daily Returns with Initial portfolio weights 03/02/2018 to 02/03/2021
port.returns1= rets3%*%port.weights
initialreturns1=as.data.frame(port.returns1)
ggplot(initialreturns1,aes(V1))+geom_histogram(color="black",fill="white")+
  theme_bw()+ggtitle("Daily Returns with Initial Weights 03/02/2018 to 02/03/2021")+
  labs(x = "Daily returns")

# Q4. Daily Returns with Optimal portfolio weights 03/02/2018 to 02/03/2021
optport1.returns=rets3%*%unname(optport1.weights)
optreturns1=as.data.frame(optport1.returns)
ggplot(optreturns1,aes(V1))+geom_histogram(color="black",fill="white")+
  theme_bw()+ggtitle("Daily Returns with Optimal Weights 03/02/2018 to 02/03/2021")+
  labs(x = "Daily returns")
skewness(port.returns1)
skewness(optport1.returns)


