import org.json.*;
import java.util.*;

public class Jsonprocessor {
    public static void main(String args[]) throws JSONException {
        JSONObject myJson = new JSONObject();
        Map < String, String > myMap = new HashMap < String, String > ();
        //map is initialized
        myMap.put("id", "1");
        myMap.put("name", "test_name");
        myMap.put("address", "test_address");

        //convert list of name:value data into JSON Object data
        System.out.println("\nList of name:value data into JSON Object data");
        try {
            myJson = new JSONObject(myMap);
            //display the json object
            System.out.println(myJson);
        } catch (Exception exception) {
            System.out.println("Data not in expected format. Error: " + exception);
        }

        //convert JSON formatted string data into JSON Object data
        System.out.println("\nJSON formatted string data into JSON Object data");
        String jsonString = "{ 'id':'1','name':'test_name','address':'test_address'}";
        try {
            JSONObject json = new JSONObject(jsonString);
            //display the json object
            System.out.println(json);
        } catch (org.json.JSONException exception) {
            System.out.println("Given string is not formated correctly! Error: " + exception);
        }


        //convert JSON data into name:value Map
        System.out.println("\nJSON data into name:value Map");
        try {
            Map mapFromJson = myJson.toMap();
            //display the Map
            System.out.println(mapFromJson.toString());
        } catch (org.json.JSONException exception) {
            System.out.println("Data is not formated correctly! Error: " + exception);
        }

        //convert JSON data into XML data
        System.out.println("\nJSON data into XML data");
        try {
            String str = XML.toString(myJson);
            //display the XML
            System.out.println(str);
        } catch (org.json.JSONException exception) {
            System.out.println("Data is not formated correctly! Error: " + exception);
        }
    }
}
